//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// array.h --
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Jul 22 10:04:20 2017
// Update Count     : 6
//

#pragma once

//#include <iterator>

// An array has contiguous elements accessible in any order using integer indicies. The first
// element has index 0.
trait array( otype array_type, otype elt_type ) {
	lvalue elt_type ?[?]( array_type, int );
};

// A bounded array is an array that carries its maximum index with it.
trait bounded_array( otype array_type, otype elt_type | array( array_type *, elt_type ) ) {
	int last( array_type * );
};

// implement iterator_for

forall( otype array_type, otype elt_type | bounded_array( array_type, elt_type ) )
[ elt_type * begin, elt_type * end ] get_iterators( array_type * );


// A bounded array can be iterated over by using a pointer to the element type. These functions
// return iterators corresponding to the first element and the one-past-the-end element, STL-style.
forall( otype array_type, otype elt_type | bounded_array( array_type, elt_type ) )
elt_type * begin( array_type * array );

// The end iterator should point one past the last element.
forall( otype array_type, otype elt_type | bounded_array( array_type, elt_type ) )
elt_type * end( array_type * array );

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa array.c" //
// End: //
