//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// LabelFixer.h --
//
// Author           : Rodolfo G. Esteves
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Jul 22 09:17:24 2017
// Update Count     : 34
//

#pragma once

#include "Common/utility.h"
#include "SynTree/SynTree.h"
#include "SynTree/Visitor.h"
#include "SynTree/Label.h"
#include "LabelGenerator.h"
#include <map>

namespace ControlStruct {
	/// normalizes label definitions and generates multi-level exit labels
	class LabelFixer final : public Visitor {
		typedef Visitor Parent;
	  public:
		LabelFixer( LabelGenerator *gen = 0 );

		std::map < Label, Statement * > *resolveJumps() throw ( SemanticError );

		using Visitor::visit;

		// Declarations
		virtual void visit( FunctionDecl *functionDecl ) override;

		// Statements
		void visit( Statement *stmt );

		virtual void visit( CompoundStmt *stmt ) override { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( NullStmt *stmt ) override { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( ExprStmt *stmt ) override { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( IfStmt *stmt ) override { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( WhileStmt *stmt ) override { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( ForStmt *stmt ) override { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( SwitchStmt *stmt ) override { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( CaseStmt *stmt ) override { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( ReturnStmt *stmt ) override { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( TryStmt *stmt ) override { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( CatchStmt *stmt ) override { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( DeclStmt *stmt ) override { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( BranchStmt *branchStmt ) override;
		virtual void visit( UntypedExpr *untyped ) override;

		Label setLabelsDef( std::list< Label > &, Statement *definition );
		template< typename UsageNode >
		void setLabelsUsg( Label, UsageNode *usage = 0 );

	  private:
		class Entry {
			public:
			Entry( Statement *to ) : definition( to ) {}
			bool defined() { return ( definition != 0 ); }
			bool insideLoop();

			Label get_label() const { return label; }
			void set_label( Label lab ) { label = lab; }

			Statement *get_definition() const { return definition; }
			void set_definition( Statement *def ) { definition = def; }

		  private:
			Label label;
			Statement *definition;
		};

		std::map < Label, Entry *> labelTable;
		LabelGenerator *generator;
	};
} // namespace ControlStruct

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
