//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Generate.cc --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Andrew Beach
// Last Modified On : Wed May 19 13:05:00 2017
// Update Count     : 6
//
#include "Generate.h"

#include <iostream>                  // for ostream, endl, operator<<
#include <list>                      // for list
#include <string>                    // for operator<<

#include "CodeGenerator.h"           // for CodeGenerator, doSemicolon, oper...
#include "GenType.h"                 // for genPrettyType
#include "Parser/LinkageSpec.h"      // for isBuiltin, isGeneratable
#include "SynTree/BaseSyntaxNode.h"  // for BaseSyntaxNode
#include "SynTree/Declaration.h"     // for Declaration
#include "SynTree/Type.h"            // for Type

using namespace std;

namespace CodeGen {
	void generate( std::list< Declaration* > translationUnit, std::ostream &os, bool doIntrinsics, bool pretty, bool generateC, bool lineMarks ) {
		CodeGen::CodeGenerator cgv( os, pretty, generateC, lineMarks );
		for ( auto & dcl : translationUnit ) {
			if ( LinkageSpec::isGeneratable( dcl->get_linkage() ) && (doIntrinsics || ! LinkageSpec::isBuiltin( dcl->get_linkage() ) ) ) {
				os << cgv.lineDirective(dcl);
				dcl->accept(cgv);
				if ( doSemicolon( dcl ) ) {
					os << ";";
				} // if
				os << std::endl;
			} // if
		} // for
	}

	void generate( BaseSyntaxNode * node, std::ostream & os ) {
		if ( Type * type = dynamic_cast< Type * >( node ) ) {
			os << CodeGen::genPrettyType( type, "" );
		} else {
			CodeGen::CodeGenerator cgv( os, true, false, false );
			node->accept( cgv );
		}
		os << std::endl;
	}
} // namespace CodeGen

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
