#include <stdio.h>
#include <assert.h>
#include <stdlib.h>

#define SHOW(x, fmt) printf( #x ": " fmt "\n", x )

#ifdef ERRS
#define ERR(...) __VA_ARGS__
#else
#define ERR(...)
#endif



int main() {

/*
As in the last section, we inspect the declaration ...
*/
    float a[3][10];
/*

*/
    static_assert(sizeof(float)==4);    // floats (atomic elements) are 4 bytes
    static_assert(sizeof(void*)==8);    // pointers are 8 bytes
/*

The significant axis of deriving expressions from @a@ is now ``itself,'' ``first element'' or ``first grand-element (meaning, first element of first element).''
*/
    static_assert(sizeof(  a       ) == 120); // the array, float[3][10]
    static_assert(sizeof(  a[0]    ) == 40 ); // its first element, float[10]
    static_assert(sizeof(  a[0][0] ) == 4  ); // its first grand element, float

    static_assert(sizeof(&(a      )) == 8  ); // pointer to the array, float(*)[3][10]
    static_assert(sizeof(&(a[0]   )) == 8  ); // pointer to its first element, float(*)[10]
    static_assert(sizeof(&(a[0][0])) == 8  ); // pointer to its first grand-element, float*

    float (*pa  )[3][10] = &(a      );
    float (*pa0 )   [10] = &(a[0]   );
    float  *pa00         = &(a[0][0]);

    static_assert((void*)&a == (void*)&(a[0]   ));
    static_assert((void*)&a == (void*)&(a[0][0]));

    assert( (void *) pa == (void *) pa0  );
    assert( (void *) pa == (void *) pa00 );

//    float (*b[3])[10];
    float *b[3];
    for (int i = 0; i < 3; i ++) {
        b[i] = malloc(sizeof(float[10]));
    }
    a[2][3];
    b[2][3];
/*

*/

}
