//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// parseutility.cc -- 
//
// Author           : Rodolfo G. Esteves
// Created On       : Sat May 16 15:30:39 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat May 16 15:31:33 2015
// Update Count     : 2
// 

#include "parseutility.h"
#include "SynTree/Type.h"
#include "SynTree/Expression.h"

Expression *notZeroExpr( Expression *orig ) {
	UntypedExpr *comparison = new UntypedExpr( new NameExpr( "?!=?" ) );
	comparison->get_args().push_back( orig );
	comparison->get_args().push_back( new NameExpr( "0" ) );
	return new CastExpr( comparison, new BasicType( Type::Qualifiers(), BasicType::SignedInt ) );
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
