######################### -*- Mode: Makefile-Gmake -*- ########################
##
## Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
##
## The contents of this file are covered under the licence agreement in the
## file "LICENCE" distributed with Cforall.
##
## module.mk -- 
##
## Author           : Peter A. Buhr
## Created On       : Sat May 16 15:29:09 2015
## Last Modified By : Peter A. Buhr
## Last Modified On : Sat May 16 15:29:50 2015
## Update Count     : 1
###############################################################################

YACC=bison
YFLAGS=-d --debug -v
LEX=flex
LFLAGS=

SRC += Parser/cfa.y \
       Parser/lex.l \
       Parser/TypedefTable.cc \
       Parser/ParseNode.cc \
       Parser/DeclarationNode.cc \
       Parser/ExpressionNode.cc \
       Parser/StatementNode.cc \
       Parser/InitializerNode.cc \
       Parser/TypeData.cc \
       Parser/LinkageSpec.cc \
       Parser/parseutility.cc \
       Parser/Parser.cc

EXTRA_OUTPUT += Parser/cfa.tab.cc \
                Parser/cfa.tab.h \
		Parser/lex.yy.cc \
		Parser/cfa.output

LIBS += -lfl

Parser/Parser.cc: Parser/cfa.tab.h

Parser/cfa.tab.cc: Parser/cfa.y
	$(YACC) $(YFLAGS) $< --file-prefix=Parser/cfa
	-mv Parser/cfa.tab.c Parser/cfa.tab.cc

Parser/cfa.tab.h: Parser/cfa.tab.cc

Parser/lex.yy.cc: Parser/lex.l Parser/cfa.tab.h Parser/TypedefTable.h
	$(LEX) $(LFLAGS) -o$@ $< 

Parser/lex.yy.o: Parser/lex.yy.cc Parser/ParseNode.h
	$(CXX) $(CXXFLAGS) -Wno-unused -c -o $@ $<
