//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
// 
// lex.h -- 
// 
// Author           : Peter A. Buhr
// Created On       : Sat Sep 22 08:58:10 2001
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat May 16 12:18:48 2015
// Update Count     : 334
//

#ifndef PARSER_LEX_H
#define PARSER_LEX_H

int yylex();
void yyerror(char *);

// External declarations for information sharing between lexer and scanner
#include "TypedefTable.h"
extern TypedefTable typedefTable;

// current location in the input
extern int yylineno;
extern char *yyfilename;

struct Location {
    char *file;
    int line;
};

class Token {
  public:
    std::string *str;
    Location loc;

    operator std::string *() { return str; }
};

#endif // PARSER_LEX_H

// Local Variables: //
// fill-column: 110 //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
