//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Parser.h -- 
//
// Author           : Rodolfo G. Esteves
// Created On       : Sat May 16 14:56:50 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat May 16 14:58:56 2015
// Update Count     : 2
//

#ifndef PARSER_H
#define PARSER_H

#include <cstdio>

#include "Parser/ParseNode.h"
#include "LinkageSpec.h"

class Parser {
  public:
	static Parser &get_parser();

	// do the actual parse
	void parse( FILE *input );

	// accessors to return the result of the parse
	DeclarationNode *get_parseTree() const { return parseTree; }
	int get_parseStatus() const { return parseStatus; }

	// mutators to control parse options
	void set_debug( bool debug );
	void set_linkage( LinkageSpec::Type linkage );

	// free the parse tree without actually destroying the parser
	void freeTree();

	~Parser();
  private:
	Parser();
	static Parser *theParser;
	DeclarationNode *parseTree;
	int parseStatus;
};

#endif // PARSER_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
