//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// LinkageSpec.h -- 
//
// Author           : Rodolfo G. Esteves
// Created On       : Sat May 16 13:24:28 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat May 16 13:26:14 2015
// Update Count     : 3
//

#ifndef LINKAGESPEC_H
#define LINKAGESPEC_H

#include <string>

struct LinkageSpec {
	enum Type {
		Intrinsic,										// C built-in defined in prelude
		Cforall,										// ordinary
		C,												// not overloadable, not mangled
		AutoGen,										// built by translator (struct assignment)
		Compiler										// gcc internal
	};
  
	static Type fromString( const std::string & );
	static std::string toString( Type );
  
	static bool isDecoratable( Type );
	static bool isGeneratable( Type );
	static bool isOverloadable( Type );
	static bool isBuiltin( Type );
};

#endif // LINKAGESPEC_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
