//---------------------------------------------------------
// Barging test
// Ensures the statement order is reverse when using waitfor ^?{}
//---------------------------------------------------------

#include <fstream>
#include <kernel>
#include <monitor>
#include <stdlib>
#include <thread>

#include <stdbool.h>

static const unsigned long N = 5_000ul;

thread dummy_t {};

void ^?{}( dummy_t & mutex this ) {
	sout | "Dtor" | endl;
}

void main( dummy_t & this ) {
	yield(((unsigned)rand48()) % 10);
	sout | "Main";
	waitfor( ^?{}, this ) {
		sout | "After waitfor";
	}
	sout | "Ending Main";
}

int main() {
	sout | "Starting" | endl;
	processor p;
	for( int i = 0; i < N; i++ ){
		dummy_t dummy;
		yield( ((unsigned)rand48()) % 100 );
	}
	sout | "Stopping" | endl;
}