//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// GenPoly.cc -- 
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Rob Schluntz
// Last Modified On : Tue Nov 24 15:23:08 2015
// Update Count     : 11
//

#include "GenPoly.h"
#include "SynTree/Type.h"

#include <iostream>
using namespace std;

namespace GenPoly {
	// A function needs an adapter if it returns a polymorphic value or if any of its
	// parameters have polymorphic type
	bool needsAdapter( FunctionType *adaptee, const TyVarMap &tyVars ) {
		if ( ! adaptee->get_returnVals().empty() && isPolyVal( adaptee->get_returnVals().front()->get_type(), tyVars ) ) {
			return true;
		} // if
		for ( std::list< DeclarationWithType* >::const_iterator innerArg = adaptee->get_parameters().begin(); innerArg != adaptee->get_parameters().end(); ++innerArg ) {
			if ( isPolyVal( (*innerArg)->get_type(), tyVars ) ) {
				return true;
			} // if
		} // for
		return false;
	}

	bool isPolyRet( FunctionType *function, std::string &name, const TyVarMap &otherTyVars ) {
		bool doTransform = false;
		if ( ! function->get_returnVals().empty() ) {
			if ( TypeInstType *typeInst = dynamic_cast< TypeInstType *>( function->get_returnVals().front()->get_type() ) ) {
	
				// figure out if the return type is specified by a type parameter
				for ( std::list< TypeDecl *>::const_iterator tyVar = function->get_forall().begin(); tyVar != function->get_forall().end(); ++tyVar ) {
					if ( (*tyVar)->get_name() == typeInst->get_name() ) {
						doTransform = true;
						name = typeInst->get_name();
						break;
					} // if
				} // for
				if ( ! doTransform && otherTyVars.find( typeInst->get_name() ) != otherTyVars.end() ) {
					doTransform = true;
				} // if
			} // if
		} // if
		return doTransform;
	}

	bool isPolyRet( FunctionType *function, std::string &name ) {
		TyVarMap dummyTyVars;
		return isPolyRet( function, name, dummyTyVars );
	}

	bool isPolyRet( FunctionType *function, const TyVarMap &otherTyVars ) {
		std::string dummyString;
		return isPolyRet( function, dummyString, otherTyVars );
	}

	bool isPolyVal( Type *type, const TyVarMap &tyVars ) {
		if ( TypeInstType *typeInst = dynamic_cast< TypeInstType * >( type ) ) {
			if ( tyVars.find( typeInst->get_name() ) != tyVars.end() ) {
				return true;
			} // if
		} // if
		return false;
	}

	bool isPolyObj( Type *type, const TyVarMap &tyVars ) {
		if ( isPolyVal( type, tyVars ) ) {
			return true;
		} else if ( PointerType *pt = dynamic_cast<PointerType*>( type ) ) {
			return isPolyObj( pt->get_base(), tyVars );
		} else {
			return false;
		}
	}

	void printTyVarMap( std::ostream &os, const TyVarMap &tyVarMap ) {
		for ( TyVarMap::const_iterator i = tyVarMap.begin(); i != tyVarMap.end(); ++i ) {
			os << i->first << " (" << i->second << ") ";
		} // for
		os << std::endl;
	}
} // namespace GenPoly

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
