#include <pthread.h>
#include <stdlib.h>
#include <signal.h>

#define __CFA_SIGCXT__ ucontext_t *
#define __CFA_SIGPARMS__ __attribute__((unused)) int sig, __attribute__((unused)) siginfo_t *sfp, __attribute__((unused)) __CFA_SIGCXT__ cxt

void sigHandler( __CFA_SIGPARMS__ ) {
	sigset_t mask;
	sigemptyset( &mask );
	sigaddset( &mask, SIGUSR1 );

	if ( sigprocmask( SIG_UNBLOCK, &mask, NULL ) == -1 ) {
		abort();
	} // if
}

int main() {

	struct sigaction act;

	act.sa_sigaction = (void (*)(int, siginfo_t *, void *))sigHandler;
	sigemptyset( &act.sa_mask );
	sigaddset( &act.sa_mask, SIGUSR1 );

	act.sa_flags = SA_SIGINFO;

	if ( sigaction( SIGUSR1, &act, NULL ) == -1 ) {
		abort();
	} // if

	for( int i = 0; i < 50000000ul; i++ ) {
		pthread_kill( pthread_self(), SIGUSR1 );
	}
}