// 
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
// 
// ato.c -- 
// 
// Author           : Peter A. Buhr
// Created On       : Thu Feb  4 08:10:57 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Nov 16 18:31:56 2017
// Update Count     : 89
// 

#include <fstream>
#include <stdlib>										// ato, strto

int main( void ) {
	const char * sptr = "-123";
	int i = ato( sptr );
	sout | i | sptr | endl;
	sptr = "123";
	unsigned int ui = ato( sptr );
	sout | ui | sptr | endl;

	sptr = "-123";
	long int li = ato( sptr );
	sout | li | sptr | endl;
	sptr = "123";
	unsigned long int uli = ato( sptr );
	sout | uli | sptr | endl;

	sptr = "-123";
	long long int lli = ato( sptr );
	sout | lli | sptr | endl;
	sptr = "123";
	unsigned long long int ulli = ato( sptr );
	sout | ulli | sptr | endl;

	sptr = "-123.456";
	float f = ato( sptr );
	sout | f | sptr | endl;
	sptr = "-123.4567890123456";
	double d = ato( sptr );
	sout | d | sptr | endl;
	sptr = "-123.45678901234567890123456789";
	long double ld = ato( sptr );
	sout | ld | sptr | endl;

	sptr = "-123.456-123.456i";
	float _Complex fc = ato( sptr );
	sout | fc | sptr | endl;
	sptr = "-123.4567890123456+123.4567890123456i";
	double _Complex dc = ato( sptr );
	sout | dc | sptr | endl;
	sptr = "123.45678901234567890123456789-123.45678901234567890123456789i";
	long double _Complex ldc = ato( sptr );
	sout | ldc | sptr | endl;
	sptr = "123.45678901234-123.4567890i";
	long double _Complex ldc2 = ato( sptr );
	sout | ldc2 | sptr | endl;


	sptr = "-123";
	i = strto( sptr, 0, 10 );
	sout | i | sptr | endl;
	sptr = "123";
	ui = strto( sptr, 0, 10 );
	sout | ui | sptr | endl;

	sptr = "-123";
	li = strto( sptr, 0, 10 );
	sout | li | sptr | endl;
	sptr = "123";
	uli = strto( sptr, 0, 10 );
	sout | uli | sptr | endl;

	sptr = "-123";
	lli = strto( sptr, 0, 10 );
	sout | lli | sptr | endl;
	sptr = "123";
	ulli = strto( sptr, 0, 10 );
	sout | ulli | sptr | endl;

	sptr = "-123.456";
	f = strto( sptr, 0 );
	sout | f | sptr | endl;
	sptr = "-123.4567890123456";
	d = strto( sptr, 0 );
	sout | d | sptr | endl;
	sptr = "-123.45678901234567890123456789";
	ld = strto( sptr, 0 );
	sout | ld | sptr | endl;

	sptr = "-123.456-123.456i";
	fc = strto( sptr, 0 );
	sout | fc | sptr | endl;

	char * eptr = 0;
	// sptr = "2fred";
	// fc = strto( sptr, &eptr );
	// sout | fc | sptr | eptr | endl;

	sptr = "2  3";
	fc = strto( sptr, &eptr );
	sout | fc | sptr | eptr | endl;

	sptr = "-123.4567890123456+123.4567890123456i";
	dc = strto( sptr, 0 );
	sout | dc | sptr | endl;
	sptr = "123.45678901234567890123456789-123.45678901234567890123456789i";
	ldc = strto( sptr, 0 );
	sout | ldc | sptr | endl;
	sptr = "123.45678901234-123.4567890i";
	ldc2 = strto( sptr, 0 );
	sout | ldc2 | sptr | endl;
} // main

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa ato.c" //
// End: //
