#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>
#include <qthread.h>

#include "bench.h"

int argc;
char **argv;

static aligned_t greeter( __attribute__((unused)) void * arg ) {
	BENCH(
		for ( size_t i = 0; i < n; i += 1 ) {
			qthread_yield();
		},
		result
	)
	printf( "%g\n", result );
	return 0;
}

int main( int margc, char *margv[] ) {
	argc = margc;
	argv = margv;

	aligned_t return_value = 0;
	int status;

	status = qthread_init( 1 );
	assert(status == QTHREAD_SUCCESS);

	status = qthread_fork( greeter, NULL, &return_value );
	assert(status == QTHREAD_SUCCESS);

	int ret = qthread_readFF( NULL, &return_value );
	assert(ret == QTHREAD_SUCCESS);

	return EXIT_SUCCESS;
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "gcc -g -O2 -Wall -I.. -I/u/pabuhr/software/qthreads/include -L/u/pabuhr/software/qthreads/lib -Xlinker -R/u/pabuhr/software/qthreads/lib qthreads.c -lqthread" //
// End: //
