"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// The module 'vscode' contains the VS Code extensibility API
// Import the module and reference it with the alias vscode in your code below
const path = require("path");
const vscode = require("vscode");


const vscode_lc = require('vscode-languageclient');

let client = {}

// this method is called when your extension is activated
// your extension is activated the very first time the command is executed
function activate(context) {
	vscode.window.showInformationMessage('Cforall Extension Starting');

	// The debug options for the server
	// --inspect=6009: runs the server in Node's Inspector mode so VS Code can attach to the server for debugging
	let debugOptions = { execArgv: ['--nolazy', '--inspect=6009'] };

	// If the extension is launched in debug mode then the debug server options are used
	// Otherwise the run options are used
	let serverOptions = {
		run: { command: 'cfa-ls', transport: vscode_lc.TransportKind.ipc },
		debug: {
			command: 'cfa-ls',
			transport: vscode_lc.TransportKind.ipc,
			options: debugOptions
		}
	};

	// Options to control the language client
	let clientOptions = {
		// Register the server for plain text documents
		documentSelector: [{ scheme: 'file', language: 'cforall' }]
	};

	// Create the language client and start the client.
	client = new vscode_lc.LanguageClient(
		'CforallServer',
		'Cforall Language Server',
		serverOptions,
		clientOptions
	);

	// Start the client. This will also launch the server
	client.start();

}
exports.activate = activate;

// this method is called when your extension is deactivated
function deactivate() { }
exports.deactivate = deactivate;