#include "log.hpp"

#include <iostream>
#include <fstream>

#include <unistd.h>
#include <sys/types.h>
#include <pwd.h>

int g_argc;
char** g_argv;

static std::ofstream create() {
      struct passwd *pw = getpwuid(getuid());
      const char *homedir = pw->pw_dir;

      std::string target = std::string(homedir) + "/.cfa-ls.log";
      return std::ofstream{ target };
}

std::ostream & log() {
      static std::ofstream log = create();
      return log;
}
