package main

import (
    "fmt"
    "time"
    "flag"
    "sync"
)

var mutex sync.Mutex

func call() {
     mutex.Lock();
     mutex.Unlock();
}
func main() {
	times := flag.Int( "times", 10000000, "loop iterations" )
	flag.Parse()
	start := time.Now()
	for i := 1; i <= *times; i += 1 {
		call();
	}
	end := time.Now()
	fmt.Printf( "%d\n", end.Sub(start) / time.Duration(*times) )
}

// Local Variables: //
// tab-width: 4 //
// End: //
