// 
// Cforall Version 1.0.0 Copyright (C) 2017 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
// 
// user_literals.c -- 
// 
// Author           : Peter A. Buhr
// Created On       : Wed Sep  6 21:40:50 2017
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Sep  6 23:19:08 2017
// Update Count     : 36
// 

#include <fstream>

struct Weight {
    double stones;
};
void ?{}( Weight & w ) { w.stones = 0; }	// constructors
void ?{}( Weight & w, double w ) { w.stones = w; }

Weight ?+?( Weight l, Weight r ) { return (Weight){ l.stones + r.stones }; }
ofstream * ?|?( ofstream * os, Weight w ) { return os | w.stones; }

Weight ?`st( double w ) { return (Weight){ w }; } // user literals
Weight ?`lb( double w ) { return (Weight){ w / 14.0 }; }
Weight ?`kg( double w ) { return (Weight) { w * 0.1575}; }

int main() {
    Weight w, hw = { 14 };
    w = 11`st + 1`lb;
    sout | w | endl;
    w = 70.3`kg;
    sout | w | endl;
    w = 155`lb;
    sout | w | endl;
    w = 0x9b`lb;		// hexadecimal weight
    sout | w | endl;
    w = 0233`lb;		// octal weight
    sout | w | endl;
    w = 5`st + 8`kg + 25`lb + hw;
    sout | w | endl;
}



// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa user_literals.c" //
// End: //
