#include <kernel>
#include <thread>

#ifndef PREEMPTION_RATE
#define PREEMPTION_RATE 10_000ul
#endif

unsigned int default_preemption() {
	return PREEMPTION_RATE;
}

#ifdef LONG_TEST
static const unsigned long N = 30_000ul;
#else
static const unsigned long N = 500ul;
#endif

static volatile int counter = 0;

thread worker_t {
	int value;
};

void ?{}( worker_t & this, int value ) {
	this.value = value;
}

void main(worker_t & this) {
	while(counter < N) {
		if( (counter % 7) == this.value ) {
			int next = __atomic_add_fetch_4(&counter, 1, __ATOMIC_SEQ_CST);
			if( (next % 100) == 0 ) printf("%d\n", (int)next);
		}
	}
}

int main(int argc, char* argv[]) {
	processor p;
	{
		worker_t w0 = 0;
		worker_t w1 = 1;
		worker_t w2 = 2;
		worker_t w3 = 3;
		worker_t w4 = 4;
		worker_t w5 = 5;
		worker_t w6 = 6;
	}
}
