// 
// Cforall Version 1.0.0 Copyright (C) 2017 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
// 
// malloc.h -- 
// 
// Author           : Peter A. Buhr
// Created On       : Thu Jul 20 15:58:16 2017
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Aug 11 09:06:31 2018
// Update Count     : 10
// 


size_t default_mmap_start();							// CFA extras
size_t default_heap_expansion();

bool traceHeap();
bool traceHeapOn();
bool traceHeapOff();

bool traceHeapTerm();
bool traceHeapTermOn();
bool traceHeapTermOff();

bool checkFree();
bool checkFreeOn();
bool checkFreeOff();

extern "C" {
size_t malloc_alignment( void * );
bool malloc_zero_fill( void * );
int malloc_stats_fd( int fd );
void * cmemalign( size_t alignment, size_t noOfElems, size_t elemSize );
} // extern "C"

extern "C" {
#include_next <malloc.h>								// has internal check for multiple expansion
} // extern "C"

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
