#pragma once

#include <exception>
#include <memory>
#include <string>
#include <typeinfo>
#include <typeindex>

class bad_cast : public std::exception {
	std::string why;
public:
	bad_cast( const std::type_index& f, const std::type_index& t ) : std::exception() {
		why = std::string{"bad cast of "} + f.name() + " to " + t.name();
	}

	~bad_cast() override = default;
	
	const char* what() const noexcept override { return why.c_str(); }
};

class object {
public:
	std::type_index get_class() const { return { typeid(*this) }; }

	template<typename T>
	T& as() {
		std::type_index from = get_class(), to = { typeid(T) };
		if ( from != to ) throw bad_cast{ from, to };
		return reinterpret_cast<T&>(*this);
	}

	template<typename T>
	const T& as() const {
		std::type_index from = get_class(), to = { typeid(T) };
		if ( from != to ) throw bad_cast{ from, to };
		return reinterpret_cast<const T&>(*this);
	}

	virtual std::unique_ptr<object> new_inst() const = 0;
	
	virtual std::unique_ptr<object> new_copy() const = 0;
	
	virtual object& operator= (const object&) = 0;
	
	virtual ~object() = default;
};

class integer : public object {
private:
	int x;

public:
	integer() = default;

	integer(int x) : x(x) {}

	std::unique_ptr<object> new_inst() const override { return std::make_unique<integer>(); }
	
	std::unique_ptr<object> new_copy() const override { return std::make_unique<integer>(*this); }

	integer& operator= (const integer& that) {
		x = that.x;
		return *this;	
	}

	object& operator= (const object& that) override {
		std::type_index from = that.get_class(), to = get_class();
		if ( from != to ) throw bad_cast{ from, to };
		return *this = reinterpret_cast<const integer&>(that);
	}

	~integer() override = default;

	integer& operator+= (const integer& that) {
		x += that.x;
		return *this;
	}
};
