#pragma once

#include "object.hpp"

class stack {
	struct node {
		std::unique_ptr<object> value;
		node* next;

		node( const object& v );

		node( std::unique_ptr<object>&& v, node* n );
	};

	node* head;

	void copy(const stack& o);

public:
	void clear();

	stack();

	stack(const stack& o);

	stack(stack&& o);

	~stack();

	stack& operator= (const stack& o);
	
	stack& operator= (stack&& o);

	bool empty() const;

	void push(std::unique_ptr<object>&& value);

	std::unique_ptr<object> pop();
};
