#include "cpp-vstack.hpp"

#include <utility>

stack::node::node( const object& v ) : value( v.new_copy() ), next( nullptr ) {}

stack::node::node( std::unique_ptr<object>&& v, node* n ) : value( std::move(v) ), next( n ) {}

void stack::copy(const stack& o) {
	node** crnt = &head;
	node* next = o.head;
	while ( next ) {
		*crnt = new node{ *next->value };
		crnt = &(*crnt)->next;
		next = next->next;
	}
	*crnt = nullptr;
}

void stack::clear() {
	node* next = head;
	while ( next ) {
		node* crnt = next;
		next = crnt->next;
		delete crnt;
	}
}

stack::stack() : head(nullptr) {}

stack::stack(const stack& o) { copy(o); }

stack::stack(stack&& o) : head(o.head) { o.head = nullptr; }

stack::~stack() { clear(); }

stack& stack::operator= (const stack& o) {
	if ( this == &o ) return *this;
	clear();
	copy(o);
	return *this;
}

stack& stack::operator= (stack&& o) {
	if ( this == &o ) return *this;
	head = o.head;
	o.head = nullptr;
	return *this;
}

bool stack::empty() const {
	return head == nullptr;
}

void stack::push(std::unique_ptr<object>&& value) {
	head = new node{ std::move(value), head };
}

std::unique_ptr<object> stack::pop() {
	node* n = head;
	head = n->next;
	std::unique_ptr<object> x = std::move(n->value);
	delete n;
	return x;
}
