#include <stdlib.h>
#include "bench.hpp"
#include "cpp-vstack.hpp"

int main(int argc, char** argv) {
	srand(20171025);

	stack s;
	REPEAT_TIMED( "push_int",
		s.push( std::make_unique<integer>( rand() ) );
	)

	stack t;
	TIMED( "copy_int", 
		t = s;
	)

	TIMED( "clear_int", 
		s.clear();
	)

	integer sum;
	REPEAT_TIMED( "pop_int",
		sum += t.pop()->as<integer>();
	)
}
