#pragma once

#include <utility>

template<typename T> class stack {
	struct node {
		T value;
		node* next;

		node( T& v ) : value(v), next(nullptr) {}
		node( T&& v, node* n ) : value(std::move(v)), next(n) {}
	};
	
	node* head;

	void copy(const stack<T>& o) {
		node** crnt = &head;
		node* next = o.head;
		while ( next ) {
			*crnt = new node{ next->value };
			crnt = &(*crnt)->next;
			next = next->next;
		}
		*crnt = nullptr;
	}

public:
	void clear() {
		node* next = head;
		while ( next ) {
			node* crnt = next;
			next = crnt->next;
			delete crnt;
		}
	}

	stack() : head(nullptr) {}

	stack(const stack<T>& o) { copy(o); }

	stack(stack<T>&& o) : head(o.head) { o.head = nullptr; }

	~stack() { clear(); }

	stack& operator= (const stack<T>& o) {
		if ( this == &o ) return *this;
		clear();
		copy(o);
		return *this;
	}

	stack& operator= (stack<T>&& o) {
		if ( this == &o ) return *this;
		head = o.head;
		o.head = nullptr;
		return *this;
	}

	bool empty() const {
		return head == nullptr;
	}

	void push(T&& value) {
		head = new node{ std::move(value), head };
	}

	T pop() {
		node* n = head;
		head = n->next;
		T x = std::move(n->value);
		delete n;
		return x;
	}
};
