#pragma once

#include <iomanip>
#include <iostream>
#include <time.h>

 #define N 100000000
 

long ms_between(clock_t start, clock_t end) {
	return (end - start) / (CLOCKS_PER_SEC / 1000);
}

#define TIMED(name, code) { \
	volatile clock_t _start, _end; \
	_start = clock(); \
	code \
	_end = clock(); \
	std::cout << name << ":\t" << std::setw(7) << ms_between(_start, _end) << std::setw(0) << " ms" << std::endl; \
}

#define REPEAT_TIMED(name, code) TIMED( name, for (int _i = 0; _i < N; ++_i) { code } )
