#pragma once

#include <stdio.h>
#include <time.h>

 #define N 100000000
 

long ms_between(clock_t start, clock_t end) {
	return (end - start) / (CLOCKS_PER_SEC / 1000);
}

#define TIMED(name, code) { \
	volatile clock_t _start, _end; \
	_start = clock(); \
	code \
	_end = clock(); \
	printf("%s:\t%7ld ms\n", name, ms_between(_start, _end)); \
}

#define REPEAT_TIMED(name, code) TIMED( name, for (int _i = 0; _i < N; ++_i) { code } )
