//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// vector_int.c -- 
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed May 27 18:38:05 2015
// Update Count     : 3
//

#include "vector_int.h"
extern "C" {
#include <stdlib.h>
#include <assert.h>
}

#define DEFAULT_CAPACITY 20

vector_int vector_int_allocate() {
	return vector_int_allocate( DEFAULT_CAPACITY );
}

vector_int vector_int_allocate( int reserve ) {
	vector_int new_vector;
	new_vector.last = -1;
	new_vector.capacity = reserve;
	new_vector.data = malloc( sizeof( int ) * reserve );
	return new_vector;
}

void vector_int_deallocate( vector_int vec ) {
	free( vec.data );
}

void reserve( vector_int *vec, int reserve ) {
	if ( reserve > vec->capacity ) {
		vec->data = realloc( vec->data, sizeof( int ) * reserve );
		vec->capacity = reserve;
	}
}

void append( vector_int *vec, int element ) {
	vec->last++;
	if ( vec->last == vec->capacity ) {
		vec->capacity *= 2;
		vec->data = realloc( vec->data, sizeof( int ) * vec->capacity );
	}
	vec->data[ vec->last ] = element;
}

// implement bounded_array

lvalue int ?[?]( vector_int vec, int index ) {
	return vec.data[ index ];
}

int last( vector_int vec ) {
	return vec.last;
}


// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa vector_int.c" //
// End: //
