/*
 * This file is part of the Cforall project
 *
 * $Id: CompoundStmt.cc,v 1.4 2005/08/29 20:59:25 rcbilson Exp $
 *
 */

#include "Statement.h"
#include "utility.h"
#include <algorithm>
#include <functional>

#include <iostream>
using namespace std;

CompoundStmt::CompoundStmt( std::list<Label> labels )
    : Statement( labels )
{
}

CompoundStmt::CompoundStmt( const CompoundStmt &other )
    : Statement( other )
{
    cloneAll( other.kids, kids );
}

CompoundStmt::~CompoundStmt()
{
    deleteAll( kids );
}

void 
CompoundStmt::print( std::ostream &os, int indent )
{
    os << "\r" << string(indent, ' ') << "CompoundStmt" << endl ;
    printAll( kids, os, indent+2 );
}





