/*
 * This file is part of the Cforall project
 *
 * $Id: GenPoly.h,v 1.4 2005/08/29 20:14:13 rcbilson Exp $
 *
 */

#ifndef GENPOLY_H
#define GENPOLY_H

#include <map>
#include <string>
#include <iostream>
#include "SynTree/Declaration.h"

namespace GenPoly {

typedef std::map< std::string, TypeDecl::Kind > TyVarMap;

// considerAllTyVars allows ignoring the contents of the TyVarMap parameter, for the situations where
// it is important only that a TypeInstType node exists.

bool needsAdapter( FunctionType *adaptee, const TyVarMap &tyVarr );
bool needsAdapter( FunctionType *adaptee, const TyVarMap &tyVars, bool considerAllTyVars );
bool isPolyFun( FunctionType *fun, const TyVarMap &tyVars );
bool isPolyVal( Type *type, const TyVarMap &tyVars );
bool isPolyVal( Type *type, const TyVarMap &tyVars, bool considerAllTyVars );
void printTyVarMap( std::ostream &os, const TyVarMap &tyVarMap );

} // namespace GenPoly

#endif
