// 
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
// 
// time.c -- 
// 
// Author           : Peter A. Buhr
// Created On       : Tue Mar 27 17:24:56 2018
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Mar 27 17:27:26 2018
// Update Count     : 2
// 

#include "time"
#include <fstream>

int main() {
	Duration d1 = 3`h, d2 = 2`s, d3 = 3.07`s, d4 = (timeval){ 12 }, d5 = (timespec){ 1, 10000 };
	sout | d1 | d2 | d3 | d4 | d5 | endl;
	int i;
	d1 = 0;
	sout | d1 | d2 | d3 | endl;
	d1 = 7`s;
	d3 = d2 = d1;
	sout | d1 | d2 | d3 | endl;
	d1 = d1 + d2;
	sout | d1 | endl;
	sout | d1 == 7`s | d1 == d2 | d1 == 0 | endl;
	sout | endl;

	Time t = { 1970, 1, 2, 0, 0, 0, 10_000_000 };
	sout | t | endl;
	t = t + d1;
	sout | t | t - t | t + d5 | t.tv | endl;
	char buf[16];
	sout | "yy/mm/dd" | [t, buf]`ymd;					// shared buf => separate calls
	sout | "mm/dd/yy" | mm_dd_yy( t, buf );
	strftime( buf, 16, "%D", t );						// %D => mm/dd/yy
	sout | "mm/dd/yy" | buf;
	sout | "dd/yy/mm" | [t, buf]`dmy | endl;
	Time c = { 2001, 7, 4, 0, 0, 1, 0 };
	sout | c | c.tv | endl;
	sout | endl;

	// Clock Newfoundland = { -3.5`h }, PST = { -8`h };	// distance from GMT (UTC)
	// sout | "Clock Resolution" | getRes() | endl
	// 	 | "Newfoundland" | getTime( Newfoundland ) | endl
	// 	 | "local" | getTime() | endl
	// 	 | "local nsec" | getTimeNsec() | endl
	// 	 | "PST" | PST() | endl;						// getTime short form
	// sout | endl;

	// http://en.cppreference.com/w/cpp/chrono/duration/operator_arith4
	Duration s = 1`h + 2 * 10`m + 70`s / 10;
	sout | "1 hour + 2*10 min + 70/10 sec = " | s | "seconds" | endl;
	sout | "Dividing that by 2 minutes gives" | s / 2`m | endl;
	sout | "Dividing that by 2 gives" | s / 2 | "seconds\n";
	sout | s | "seconds is" | s`h | "hours," | (s % 1`h)`m | "minutes," | (s % 1`m)`s | "seconds" | endl;
} // main

// Local Variables: //
// mode: c //
// tab-width: 4 //
// End: //
