package main
import "fmt"
func main() {
	type Msg struct{ i, j int }

	ch1 := make( chan int )
	ch2 := make( chan float32 )
	ch3 := make( chan Msg )
	hand := make( chan string )
	shake := make( chan string )
	gortn := func() { // thread starts
		var i int;  var f float32;  var m Msg
		L: for {
			select { // wait for message
			  case i = <- ch1: fmt.Println( i )
			  case f = <- ch2: fmt.Println( f )
			  case m = <- ch3: fmt.Println( m )
			  case <- hand: break L // sentinel
			}
		}
		shake <- "SHAKE" // completion
	}

	go gortn() // start thread
	ch1 <- 0 // different messages
	ch2 <- 2.5
	ch3 <- Msg{1, 2}
	hand <- "HAND" // sentinel value
	<- shake // wait for completion
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "go run channels.go" //
// End: //
