//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Tuples.h --
//
// Author           : Rodolfo G. Esteves
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon May 18 15:04:02 2015
// Update Count     : 2
//

#ifndef _TUPLES_H_
#define _TUPLE_H_

#include <string>
#include <vector>
#include "ResolvExpr/AlternativeFinder.h"

#include "SynTree/Expression.h"
#include "SynTree/Declaration.h"
#include "SynTree/Type.h"

namespace Tuples {
	// TupleAssignment.cc
	void handleTupleAssignment( ResolvExpr::AlternativeFinder & currentFinder, UntypedExpr * assign, std::list<ResolvExpr::AltList> & possibilities );

	// TupleExpansion.cc
	void expandTuples( std::list< Declaration * > & translationUnit );

  void expandUniqueExpr( std::list< Declaration * > & translationUnit );

  TupleType * makeTupleType( const std::list< Expression * > & exprs );
} // namespace Tuples

#endif // _TUPLE_ASSIGNMENT_H_

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
