//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Alternative.cc --
//
// Author           : Richard C. Bilson
// Created On       : Sat May 16 23:44:23 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat May 16 23:54:23 2015
// Update Count     : 2
//

#include "Alternative.h"
#include "SynTree/Type.h"
#include "SynTree/Expression.h"
#include "Common/utility.h"

namespace ResolvExpr {
	Alternative::Alternative() : cost( Cost::zero ), cvtCost( Cost::zero ), expr( 0 ) {}

	Alternative::Alternative( Expression *expr, const TypeEnvironment &env, const Cost& cost )
		: cost( cost ), cvtCost( Cost::zero ), expr( expr ), env( env ) {}

	Alternative::Alternative( Expression *expr, const TypeEnvironment &env, const Cost& cost, const Cost &cvtCost )
		: cost( cost ), cvtCost( cvtCost ), expr( expr ), env( env ) {}

	Alternative::Alternative( const Alternative &other ) {
		initialize( other, *this );
	}

	Alternative &Alternative::operator=( const Alternative &other ) {
		if ( &other == this ) return *this;
		initialize( other, *this );
		return *this;
	}

	Alternative::Alternative( Alternative && other ) : cost( other.cost ), cvtCost( other.cvtCost ), expr( other.expr ), env( other.env ) {
		other.expr = nullptr;
	}

	Alternative & Alternative::operator=( Alternative && other ) {
		if ( &other == this )  return *this;
		delete expr;
		cost = other.cost;
		cvtCost = other.cvtCost;
		expr = other.expr;
		env = other.env;
		other.expr = nullptr;
		return *this;
	}

	void Alternative::initialize( const Alternative &src, Alternative &dest ) {
		dest.cost = src.cost;
		dest.cvtCost = src.cvtCost;
		dest.expr = maybeClone( src.expr );
		dest.env = src.env;
	}

	Alternative::~Alternative() {
		delete expr;
	}

	void Alternative::print( std::ostream &os, int indent ) const {
		os << std::string( indent, ' ' ) << "Cost " << cost << ": ";
		if ( expr ) {
			expr->print( os, indent );
			os << "(types:" << std::endl;
			os << std::string( indent+4, ' ' );
			expr->get_result()->print( os, indent + 4 );
			os << std::endl << ")" << std::endl;
		} else {
			os << "Null expression!" << std::endl;
		} // if
		os << std::string( indent, ' ' ) << "Environment: ";
		env.print( os, indent+2 );
		os << std::endl;
	}
} // namespace ResolvExpr

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
