#!/usr/bin/nawk -f

BEGIN {
	print "Freed but not allocated:"
}

/malloc/ {
	alloc[ $2 ] = $3;
}

/free/ {
	if ( $2 in alloc ) {
		delete alloc[ $2 ];
	} else {
		print $2;
	} # if
}

END {
	print "Allocated but not freed:"
	for ( i in alloc ) {
		print i, alloc[ i ];
		total += alloc[ i ]
	} # for
	print "total", total;
}
