//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// ScrubTyVars.h -- 
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue May 19 07:48:14 2015
// Update Count     : 1
//

#ifndef _SCRUBTYVARS_H
#define _SCRUBTYVARS_H

#include <string>

#include "GenPoly.h"

#include "SynTree/SynTree.h"
#include "SynTree/Mutator.h"

namespace GenPoly {
	class ScrubTyVars : public Mutator {
	  public:
		ScrubTyVars( const TyVarMap &tyVars ): tyVars( tyVars ) {}

		/// For all polymorphic types with type variables in `tyVars`, replaces generic types, dtypes, and ftypes with the appropriate void type,
		/// and sizeof/alignof expressions with the proper variable
		template< typename SynTreeClass >
		static SynTreeClass *scrub( SynTreeClass *target, const TyVarMap &tyVars );

		virtual Type* mutate( TypeInstType *typeInst );
		virtual Type* mutate( StructInstType *structInst );
		virtual Type* mutate( UnionInstType *unionInst );
		virtual Expression* mutate( SizeofExpr *szeof );
		virtual Expression* mutate( AlignofExpr *algnof );
		virtual Type* mutate( PointerType *pointer );

	  private:
		/// Mutates (possibly generic) aggregate types appropriately
		Type* mutateAggregateType( Type *ty );
		
		const TyVarMap &tyVars;
	};

	/* static class method */
	template< typename SynTreeClass >
	SynTreeClass * ScrubTyVars::scrub( SynTreeClass *target, const TyVarMap &tyVars ) {
		ScrubTyVars scrubber( tyVars );
		return static_cast< SynTreeClass * >( target->acceptMutator( scrubber ) );
	}

} // namespace GenPoly

#endif // _SCRUBTYVARS_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
