//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Indexer.h -- 
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 21:38:55 2015
// Last Modified By : Rob Schluntz
// Last Modified On : Thu Sep 17 16:05:38 2015
// Update Count     : 5
//

#ifndef INDEXER_H
#define INDEXER_H

#include <list>
#include <string>

#include "SynTree/Visitor.h"
#include "IdTable.h"
#include "AggregateTable.h"
#include "TypeTable.h"

namespace SymTab {
	class Indexer : public Visitor {
	  public:
		Indexer( bool useDebug = false );
		virtual ~Indexer();

		//using Visitor::visit;
		virtual void visit( ObjectDecl *objectDecl );
		virtual void visit( FunctionDecl *functionDecl );
		virtual void visit( TypeDecl *typeDecl );
		virtual void visit( TypedefDecl *typeDecl );
		virtual void visit( StructDecl *aggregateDecl );
		virtual void visit( UnionDecl *aggregateDecl );
		virtual void visit( EnumDecl *aggregateDecl );
		virtual void visit( ContextDecl *aggregateDecl );

		virtual void visit( CompoundStmt *compoundStmt );

		virtual void visit( ApplicationExpr *applicationExpr );
		virtual void visit( UntypedExpr *untypedExpr );
		virtual void visit( NameExpr *nameExpr );
		virtual void visit( CastExpr *castExpr );
		virtual void visit( AddressExpr *addressExpr );
		virtual void visit( LabelAddressExpr *labAddressExpr );
		virtual void visit( UntypedMemberExpr *memberExpr );
		virtual void visit( MemberExpr *memberExpr );
		virtual void visit( VariableExpr *variableExpr );
		virtual void visit( ConstantExpr *constantExpr ); 
		virtual void visit( SizeofExpr *sizeofExpr );
		virtual void visit( AlignofExpr *alignofExpr );
		virtual void visit( OffsetofExpr *offsetofExpr );
		virtual void visit( AttrExpr *attrExpr );
		virtual void visit( LogicalExpr *logicalExpr );
		virtual void visit( ConditionalExpr *conditionalExpr );
		virtual void visit( CommaExpr *commaExpr );
		virtual void visit( TupleExpr *tupleExpr );
		virtual void visit( SolvedTupleExpr *tupleExpr );
		virtual void visit( TypeExpr *typeExpr );
		virtual void visit( AsmExpr *asmExpr );
		virtual void visit( UntypedValofExpr *valofExpr );

		virtual void visit( ContextInstType *contextInst );
		virtual void visit( StructInstType *contextInst );
		virtual void visit( UnionInstType *contextInst );

		virtual void visit( ForStmt *forStmt );

		// when using an indexer manually (e.g., within a mutator traversal), it is necessary to tell the indexer
		// explicitly when scopes begin and end
		void enterScope();
		void leaveScope();

		void lookupId( const std::string &id, std::list< DeclarationWithType* >& ) const;
		DeclarationWithType* lookupId( const std::string &id) const;
		NamedTypeDecl *lookupType( const std::string &id ) const;
		StructDecl *lookupStruct( const std::string &id ) const;
		EnumDecl *lookupEnum( const std::string &id ) const;
		UnionDecl *lookupUnion( const std::string &id ) const;
		ContextDecl *lookupContext( const std::string &id ) const;
  
		void print( std::ostream &os, int indent = 0 ) const;
	  private:
		IdTable idTable;
		TypeTable typeTable;
		StructTable structTable;
		EnumTable enumTable;
		UnionTable unionTable;
		ContextTable contextTable;
  
		bool doDebug;					// display debugging trace
	};
} // namespace SymTab

#endif // INDEXER_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
