//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Constant.cc -- 
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Jul 30 15:18:38 2015
// Update Count     : 12
//

#include <iostream>
#include <list>
#include <string>

#include "Constant.h"
#include "Type.h"

Constant::Constant( Type *type_, std::string value_ ) : type( type_ ), value( value_ ) {}

Constant::Constant( const Constant &other ) {
	type = other.type->clone();
	value = other.value;
}

Constant::~Constant() { delete type; }

Constant Constant::from( int i ) {
	return Constant( new BasicType( Type::Qualifiers(), BasicType::SignedInt ), std::to_string( i ) );
}

Constant Constant::from( unsigned long i ) {
	return Constant( new BasicType( Type::Qualifiers(), BasicType::LongUnsignedInt ), std::to_string( i ) );
}

Constant Constant::from( double d ) {
	return Constant( new BasicType( Type::Qualifiers(), BasicType::Double ), std::to_string( d ) );
}

Constant *Constant::clone() const { assert( false ); return 0; }

void Constant::print( std::ostream &os ) const {
	os << "(" << value;
	if ( type ) {
		os << ": ";
		type->print( os );
	} // if
  os << ")";
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
