//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// iostream.c -- 
//
// Author           : Peter A. Buhr
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Mar  2 18:06:35 2016
// Update Count     : 208
//

#include "iostream"

extern "C" {
#include <stdio.h>
#include <string.h>										// strlen
#include <float.h>										// DBL_DIG, LDBL_DIG
#include <complex.h>									// creal, cimag
#include <ctype.h>										// isspace, ispunct
}

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, char c ) {
	prtfmt( os, "%c", c );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, short int si ) {
	if ( sepPrt( os ) ) prtfmt( os, "%s", sepGet( os ) ); else sepOn( os );
	prtfmt( os, "%hd", si );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, unsigned short int usi ) {
	if ( sepPrt( os ) ) prtfmt( os, "%s", sepGet( os ) ); else sepOn( os );
	prtfmt( os, "%hu", usi );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, int i ) {
	if ( sepPrt( os ) ) prtfmt( os, "%s", sepGet( os ) ); else sepOn( os );
	prtfmt( os, "%d", i );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, unsigned int ui ) {
	if ( sepPrt( os ) ) prtfmt( os, "%s", sepGet( os ) ); else sepOn( os );
	prtfmt( os, "%u", ui );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, long int li ) {
	if ( sepPrt( os ) ) prtfmt( os, "%s", sepGet( os ) ); else sepOn( os );
	prtfmt( os, "%ld", li );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, unsigned long int uli ) {
	if ( sepPrt( os ) ) prtfmt( os, "%s", sepGet( os ) ); else sepOn( os );
	prtfmt( os, "%lu", uli );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, long long int lli ) {
	if ( sepPrt( os ) ) prtfmt( os, "%s", sepGet( os ) ); else sepOn( os );
	prtfmt( os, "%lld", lli );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, unsigned long long int ulli ) {
	if ( sepPrt( os ) ) prtfmt( os, "%s", sepGet( os ) ); else sepOn( os );
	prtfmt( os, "%llu", ulli );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, float f ) {
	if ( sepPrt( os ) ) prtfmt( os, "%s", sepGet( os ) ); else sepOn( os );
	prtfmt( os, "%g", f );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, double d ) {
	if ( sepPrt( os ) ) prtfmt( os, "%s", sepGet( os ) ); else sepOn( os );
	prtfmt( os, "%.*lg", DBL_DIG, d );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, long double ld ) {
	if ( sepPrt( os ) ) prtfmt( os, "%s", sepGet( os ) ); else sepOn( os );
	prtfmt( os, "%.*Lg", LDBL_DIG, ld );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, float _Complex fc ) {
	os | crealf( fc );
	if ( cimagf( fc ) >= 0 ) os | '+';
	os | "" | cimagf( fc ) | 'i';
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, double _Complex dc ) {
	os | creal( dc );
	if ( cimag( dc ) >= 0 ) os | '+';
	os | "" | cimag( dc ) | 'i';
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, long double _Complex ldc ) {
	os | creall( ldc );
	if ( cimagl( ldc ) >= 0 ) os | '+';
	os | "" | cimagl( ldc ) | 'i';
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, const char *cp ) {
	int len = strlen( cp );
	// null string => no separator
  if ( len == 0 ) { sepOff( os ); return os; }
	// first character NOT spacing or special punctuation => add left separator
	if ( sepPrt( os ) && isspace( cp[0] ) == 0 && cp[0] != '.' && cp[0] != ',' ) {
		prtfmt( os, "%s", sepGet( os ) );
	} // if
	// last character is spacing or special punctuation => turn off separator for next item
	unsigned int posn = len - 1;
	if ( isspace( cp[posn] ) || cp[posn] == ':' || cp[posn] == '$' ) {
		sepOff( os );
	} else {
		sepOn( os );
	} // if
	return write( os, cp, len );
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, const void *p ) {
	if ( sepPrt( os ) ) prtfmt( os, "%s", sepGet( os ) ); else sepOn( os );
	prtfmt( os, "%p", p );
	return os;
} // ?|?


forall( dtype ostype | ostream( ostype ) ) 
ostype * ?|?( ostype *os, ostype * (* manip)( ostype * ) ) {
	return manip( os );
} // ?|?

forall( dtype ostype | ostream( ostype ) ) 
ostype * endl( ostype * os ) {
	os | '\n';
	flush( os );
	sepOff( os );
	return os;
} // endl

forall( dtype ostype | ostream( ostype ) ) 
ostype * sepOn( ostype * os ) {
	sepOn( os );
	return os;
} // sepOn

forall( dtype ostype | ostream( ostype ) ) 
ostype * sepOff( ostype * os ) {
	sepOff( os );
	return os;
} // sepOff

//---------------------------------------

forall( otype elttype | writeable( elttype ), otype iteratortype | iterator( iteratortype, elttype ), dtype ostype | ostream( ostype ) )
void write( iteratortype begin, iteratortype end, ostype *os ) {
	void print( elttype i ) { os | i; }
	for_each( begin, end, print );
} // ?|?

forall( otype elttype | writeable( elttype ), otype iteratortype | iterator( iteratortype, elttype ), dtype ostype | ostream( ostype ) )
void write_reverse( iteratortype begin, iteratortype end, ostype *os ) {
	void print( elttype i ) { os | i; }
	for_each_reverse( begin, end, print );
} // ?|?

//---------------------------------------

forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, char * c ) {
	scanfmt( is, "%c", c );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, short int * si ) {
	scanfmt( is, "%hd", si );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, unsigned short int * usi ) {
	scanfmt( is, "%hu", usi );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, int * i ) {
	scanfmt( is, "%d", i );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, unsigned int * ui ) {
	scanfmt( is, "%u", ui );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, long int * li ) {
	scanfmt( is, "%ld", li );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, unsigned long int * ulli ) {
	scanfmt( is, "%lu", ulli );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, long long int * lli ) {
	scanfmt( is, "%lld", lli );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, unsigned long long int * ulli ) {
	scanfmt( is, "%llu", ulli );
	return is;
} // ?|?


forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, float * f ) {
	scanfmt( is, "%f", f );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, double * d ) {
	scanfmt( is, "%lf", d );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, long double * ld ) {
	scanfmt( is, "%Lf", ld );
	return is;
} // ?|?


forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, float _Complex * fc ) {
	float re, im;
	scanfmt( is, "%g%gi", &re, &im );
	*fc = re + im * _Complex_I;
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, double _Complex * dc ) {
	double re, im;
	scanfmt( is, "%lf%lfi", &re, &im );
	*dc = re + im * _Complex_I;
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, long double _Complex * ldc ) {
	long double re, im;
	scanfmt( is, "%Lf%Lfi", &re, &im );
	*ldc = re + im * _Complex_I;
	return is;
} // ?|?

_Istream_str1 str( char * s ) { _Istream_str1 s = { s }; return s; }
forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, _Istream_str1 str ) {
	scanfmt( is, "%s", str.s );
	return is;
} // str

_Istream_str2 str( char * s, int size ) { _Istream_str2 s = { s, size }; return s; }
forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, _Istream_str2 str ) {
	char buf[16];
	sprintf( buf, "%%%ds", str.size );
	scanfmt( is, buf, str.s );
	return is;
} // str

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa iostream.c" //
// End: //
