//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// prolog.c -- 
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Mar  2 18:11:18 2016
// Update Count     : 2
//

extern "C" { extern int printf( const char *fmt, ... ); }

void printResult( int x ) { printf( "int\n" ); }
void printResult( double x ) { printf( "double\n" ); }
void printResult( char * x ) { printf( "char*\n" ); }

void is_arithmetic( int x ) {}
void is_arithmetic( double x ) {}

void is_integer( int x ) {}

trait ArithmeticType( type T ) {
	void is_arithmetic( T );
};

trait IntegralType( type T | ArithmeticType( T ) ) {
	void is_integer( T );
};

forall( type T | IntegralType( T ) | { void printResult( T ); } )
void hornclause( T param ) {
	printResult( param );
}

int main() {
	int x;
	double x;
	char * x;
	hornclause( x );
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa prolog.c" //
// End: //
