# set terminal pdfcairo size 6.25,2.125
# set output "tests-completed.pdf"
set terminal pslatex size 6.25,3.25 color solid
set output BUILD."tests-completed.tex"

set linetype 1 lc rgb 'black'
set linetype 2 lc rgb 'red'
set linetype 3 lc rgb 'blue'
set linetype 4 lc rgb 'green'

set style data histogram
set style fill pattern 4 border lt -1
unset key
set xtics rotate #by 45 offset -7.5,-4.5

# TESTS COMPLETED #
set yrange [0:131]

plot 'evaluation/algo-summary.dat' using ($5 == 1 ? $2 : 1/0):xtic(1) with boxes, \
	'' using ($5 == 2 ? $2 : 1/0):xtic(1) with boxes, \
	'' using ($5 == 3 ? $2 : 1/0):xtic(1) with boxes 

# BU AVG. RUNTIME #
set output BUILD."bu-runtime.tex"

unset yrange
set ylabel "ms"

plot 'evaluation/bu-summary.dat' using 3:xtic(1) with boxes

# AVG. RUNTIME #
set output BUILD."avg-runtime.tex"

plot 'evaluation/algo-summary.dat' using ($5 == 1 ? $4 : 1/0):xtic(1) with boxes, \
	'' using ($5 == 2 ? $4 : 1/0):xtic(1) with boxes, \
	'' using ($5 == 3 ? $4 : 1/0):xtic(1) with boxes

# BU AVG. PEAK MEMORY #
set output BUILD."bu-peak-mem.tex"

set ylabel "MB"

plot 'evaluation/bu-summary.dat' using 2:xtic(1) with boxes

# AVG. PEAK MEMORY #
set output BUILD."avg-peak-mem.tex"

set yrange [0:80]

set label "125" at 18.25,82
set label "322" at 19.75,82
plot 'evaluation/algo-summary.dat' using ($5 == 1 ? $3 : 1/0):xtic(1) with boxes, \
	'' using ($5 == 2 ? $3 : 1/0):xtic(1) with boxes, \
	'' using ($5 == 3 ? $3 : 1/0):xtic(1) with boxes