# set terminal pdfcairo size 6,3
# BUILD = "build/"
set terminal pslatex size 6.25,2.5 color solid

set datafile separator ","

tests = "io1 io2 math1 math2 math3 math4 minmax rational searchsort swap kernel preemption imgui"

# BY DEPTH #
set output BUILD."per-prob-depth.tex"

set xlabel "max depth"
set ylabel "runtime (ms)"
set logscale xy

set key outside

plot for [i=1:words(tests)] 'evaluation/per_prob/'.word(tests, i).'-per-prob.csv' using 2:(column(7)/1000) title word(tests, i)

# # BY PARAMETER LIST WIDTH #
# set output BUILD."per-prob-params.pdf"

# set xlabel "max params"

# plot for [i=1:words(tests)] 'evaluation/per_prob/'.word(tests, i).'-per-prob.csv' using 3:(column(7)/1000) title word(tests, i)

# BY SUBEXPRS #
set output BUILD."per-prob-subs.tex"

set xlabel "number of subexpressions"

plot for [i=1:words(tests)] 'evaluation/per_prob/'.word(tests, i).'-per-prob.csv' using 4:(column(7)/1000) title word(tests, i)

# # BY MAX OVERLOADS #
# set output BUILD."per-prob-overloads.pdf"

# set xlabel "max name overloads"

# plot for [i=1:words(tests)] 'evaluation/per_prob/'.word(tests, i).'-per-prob.csv' using 5:(column(7)/1000) title word(tests, i)

# BY ASSERTIONS #
set output BUILD."per-prob-assns.tex"

set xlabel "assertions satisfied"

plot for [i=1:words(tests)] 'evaluation/per_prob/'.word(tests, i).'-per-prob.csv' using 6:(column(7)/1000) title word(tests, i)

