//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// ApplicationExpr.cc.cc --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Rob Schluntz
// Last Modified On : Tue Apr 26 12:41:06 2016
// Update Count     : 4
//

#include <cassert>               // for strict_dynamic_cast, assert
#include <list>                  // for list
#include <map>                   // for _Rb_tree_const_iterator, map, map<>:...
#include <memory>                // for unique_ptr
#include <ostream>               // for operator<<, ostream, basic_ostream
#include <string>                // for operator<<, string, char_traits
#include <utility>               // for pair

#include "Common/utility.h"      // for maybeClone, cloneAll, deleteAll, pri...
#include "Declaration.h"         // for Declaration
#include "Expression.h"          // for ParamEntry, ApplicationExpr, Expression
#include "ResolvExpr/typeops.h"  // for extractResultType
#include "Type.h"                // for Type, PointerType, FunctionType

ParamEntry::ParamEntry( const ParamEntry &other ) :
		decl( other.decl ), declptr( maybeClone( other.declptr ) ), actualType( maybeClone( other.actualType ) ), formalType( maybeClone( other.formalType ) ), expr( maybeClone( other.expr ) )/*, inferParams( new InferredParams( *other.inferParams ) )*/ {
}

ParamEntry &ParamEntry::operator=( const ParamEntry &other ) {
	if ( &other == this ) return *this;
	const_cast<UniqueId &>(decl) = other.decl;
	const_cast<Declaration * &>(declptr) = maybeClone( other.declptr );
	// xxx - this looks like a memory leak
	const_cast<Type * &>(actualType) = maybeClone( other.actualType );
	const_cast<Type * &>(formalType) = maybeClone( other.formalType );
	expr = maybeClone( other.expr );
	// *inferParams = *other.inferParams;
	return *this;
}

ParamEntry::~ParamEntry() {
	delete declptr;
	delete actualType;
	delete formalType;
	delete expr;
}

ParamEntry::ParamEntry( ParamEntry && other ) :
		decl( other.decl ), declptr( other.declptr ), actualType( other.actualType ), formalType( other.formalType ), expr( other.expr )/*, inferParams( std::move( other.inferParams ) )*/ {
	const_cast<Declaration * &>(other.declptr) = nullptr;
	const_cast<Type * &>(other.actualType) = nullptr;
	const_cast<Type * &>(other.formalType) = nullptr;
	other.expr = nullptr;
}

ParamEntry & ParamEntry::operator=( ParamEntry && other ) {
	if ( &other == this ) return *this;
	delete declptr;
	delete actualType;
	delete formalType;
	delete expr;
	const_cast<UniqueId &>(decl) = other.decl;
	const_cast<Declaration * &>(declptr) = other.declptr;
	const_cast<Type * &>(actualType) = other.actualType;
	const_cast<Type * &>(formalType) = other.formalType;
	expr = other.expr;
	const_cast<Declaration * &>(other.declptr) = nullptr;
	const_cast<Type * &>(other.actualType) = nullptr;
	const_cast<Type * &>(other.formalType) = nullptr;
	other.expr = nullptr;
	// inferParams = std::move( other.inferParams );
	return *this;
}

ApplicationExpr::ApplicationExpr( Expression *funcExpr, const std::list<Expression *> & args ) : function( funcExpr ), args( args ) {
	PointerType *pointer = strict_dynamic_cast< PointerType* >( funcExpr->get_result() );
	FunctionType *function = strict_dynamic_cast< FunctionType* >( pointer->get_base() );

	set_result( ResolvExpr::extractResultType( function ) );

	assert( result );
}

ApplicationExpr::ApplicationExpr( const ApplicationExpr &other ) :
		Expression( other ), function( maybeClone( other.function ) ) {
	cloneAll( other.args, args );
}

ApplicationExpr::~ApplicationExpr() {
	delete function;
	deleteAll( args );
}

void ApplicationExpr::print( std::ostream &os, Indenter indent ) const {
	os << "Application of" << std::endl << indent+1;
	function->print( os, indent+1 );
	os << std::endl;
	if ( ! args.empty() ) {
		os << indent << "... to arguments" << std::endl;
		printAll( args, os, indent+1 );
	} // if
	Expression::print( os, indent );
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
