#!/bin/bash

set -e

GIT="git --git-dir=$1/.git"

GIT_UPDATE="$2/GIT_UPDATE"
GIT_LOG="$2/GIT_LOG"
GIT_DIFF="$2/GIT_DIFF"

rm -f ${GIT_UPDATE}  ${GIT_LOG}  ${GIT_DIFF}

GitOldRef=$3
GitNewRef=$4


revisions=$(git rev-list ${GitOldRef}..${GitNewRef})

for rev in ${revisions}; do
    type=$(git cat-file -t ${rev})
    echo "       via  ${rev} (${type})" >>  ${GIT_UPDATE}
done
rev=${GitOldRef}
type=$(git cat-file -t ${rev})
echo "      from  ${rev} (${type})" >>  ${GIT_UPDATE}

git rev-list --format=short ${GitOldRef}...${GitNewRef} >  ${GIT_LOG}

git diff --stat ${GitNewRef} ${GitOldRef} >  ${GIT_DIFF}