//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// ResolveTypeof.cc --
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 12:12:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue May 19 16:49:04 2015
// Update Count     : 3
//

#include "ResolveTypeof.h"
#include "Alternative.h"
#include "AlternativeFinder.h"
#include "Resolver.h"
#include "TypeEnvironment.h"
#include "SynTree/Expression.h"
#include "SynTree/Type.h"

namespace ResolvExpr {
	namespace {
#if 0
		void
		printAlts( const AltList &list, std::ostream &os, int indent = 0 )
		{
			for ( AltList::const_iterator i = list.begin(); i != list.end(); ++i ) {
				i->print( os, indent );
				os << std::endl;
			}
		}
#endif
	}

	class ResolveTypeof : public Mutator {
	  public:
		ResolveTypeof( const SymTab::Indexer &indexer ) : indexer( indexer ) {}
		Type *mutate( TypeofType *typeofType );

	  private:
		const SymTab::Indexer &indexer;
	};

	Type *resolveTypeof( Type *type, const SymTab::Indexer &indexer ) {
		ResolveTypeof mutator( indexer );
		return type->acceptMutator( mutator );
	}

	Type *ResolveTypeof::mutate( TypeofType *typeofType ) {
#if 0
		std::cout << "resolving typeof: ";
		typeofType->print( std::cout );
		std::cout << std::endl;
#endif
		if ( typeofType->get_expr() ) {
			Expression *newExpr = resolveInVoidContext( typeofType->get_expr(), indexer );
			assert( newExpr->has_result() && ! newExpr->get_result()->isVoid() );
			Type *newType = newExpr->get_result();
			delete typeofType;
			return newType;
		} // if
		return typeofType;
	}
} // namespace ResolvExpr

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
