//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// AlternativePrinter.cc --
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 06:53:19 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun May 17 06:55:05 2015
// Update Count     : 2
//

#include "AlternativePrinter.h"
#include "AlternativeFinder.h"
#include "Alternative.h"
#include "SynTree/Statement.h"
#include "SynTree/Type.h"
#include "SynTree/Expression.h"
#include "Common/utility.h"

namespace ResolvExpr {
	AlternativePrinter::AlternativePrinter( std::ostream &os ) : SymTab::Indexer( false ), os( os ) {}

	void AlternativePrinter::visit( ExprStmt *exprStmt ) {
		TypeEnvironment env;
		AlternativeFinder finder( *this, env );
		finder.findWithAdjustment( exprStmt->get_expr() );
		int count = 1;
		os << "There are " << finder.get_alternatives().size() << " alternatives" << std::endl;
		for ( AltList::const_iterator i = finder.get_alternatives().begin(); i != finder.get_alternatives().end(); ++i ) {
			os << "Alternative " << count++ << " ==============" << std::endl;
			i->expr->get_result()->print( os );
			//    i->print( os );
			os << std::endl;
		} // for
	} // AlternativePrinter::visit
} // namespace ResolvExpr

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
