//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// swap.c -- 
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed May 27 18:34:47 2015
// Update Count     : 1
//

extern "C" {
	int printf( const char *, ... );
}

forall( type T )
void swap( T *left, T *right ) {
	T temp = *left;
	*left = *right;
	*right = temp;
}

int main() {
	int x = 1, y = 2;
	printf( "%d %d\n", x, y );
	swap( &x, &y );
	printf( "%d %d\n", x, y );
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa swap.c" //
// End: //
