// 
// Cforall Version 1.0.0 Copyright (C) 2017 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
// 
// fmtLines.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Sun Sep 17 21:56:15 2017
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Sep 18 11:35:57 2017
// Update Count     : 31
// 

#include <fstream>
#include <coroutine>

coroutine Format {
	char ch;											// used for communication
	int g, b;											// global because used in destructor
};

void ?{}( Format & fmt ) {
    resume( fmt );										// start coroutine
}

void ^?{}( Format & fmt ) {
    if ( fmt.g != 0 || fmt.b != 0 ) sout | endl;
}

void main( Format & fmt ) {
	for ( ;; ) {										// for as many characters
		for ( fmt.g = 0; fmt.g < 5; fmt.g += 1 ) {		// groups of 5 blocks
			for ( fmt.b = 0; fmt.b < 4; fmt.b += 1 ) {	// blocks of 4 characters
				for ( ;; ) {							// for newline characters
					suspend();
					if ( fmt.ch != '\n' ) break;		// ignore newline
				} // for
				sout | fmt.ch;							// print character
			} // for
			sout | "  ";								// print block separator
		} // for
		sout | endl;									// print group separator
	} // for
} // main

void prt( Format & fmt, char ch ) {
    fmt.ch = ch;
    resume( fmt );
} // prt

int main() {
	Format fmt;
	char ch;

	for ( ;; ) {
		sin | ch;										// read one character
	  if ( eof( sin ) ) break;							// eof ?
		prt( fmt, ch );
	} // for
} // main

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa fmtLines.c" //
// End: //
