#include <fstream>
#include <kernel>
#include <monitor>
#include <thread>

enum state_t { WAIT, SIGNAL, BARGE };

monitor global_t {};

monitor global_data_t {
	bool done;
	int counter;
	state_t state;
};

void ?{} ( global_data_t * this ) {
	this->done = false;
	this->counter = 0;
	this->state = BARGE;
}

void ^?{} ( global_data_t * this ) {}

global_t globalA;
global_t globalB;
global_data_t globalC;

condition cond;

thread Threads {};

bool logicC( global_t * mutex a, global_t * mutex b, global_data_t * mutex c ) {
	c->counter++;

	int action = c->counter % 10;

	if( action == 1 || action == 3 ) {
		if(c->state != BARGE) {
			sout | "ERROR Mutual exclusion is inconsistent for wait" | endl;
			abort();
		}

		c->state = WAIT;
		wait( &cond );

		if(c->state != SIGNAL) {
			sout | "ERROR Barging detected" | endl;
			abort();
		}
	}
	else if( action == 6 ) {
		if(c->state != BARGE) {
			sout | "ERROR Mutual exclusion is inconsistent for signal" | endl;
			abort();
		}

		c->state = SIGNAL;

		signal( &cond );
		signal( &cond );
	}
	else {
		c->state = BARGE;
	}

	if( (c->counter % 1000) == 0 ) sout | c->counter | endl;
	if( c->counter == 100_000 ) c->done = true;
	return !c->done;
}

bool logicB( global_t * mutex a, global_t * mutex b ) {
	return logicC(a, b, &globalC);
}

bool logicA( global_t * mutex a ) {
	return logicB(a, &globalB);
}

void main( Threads* this ) {
	while( logicA(&globalA) ) { yield(); };
}

int main(int argc, char* argv[]) {
	processor p[3];
	{
		Threads t[20];
	}
}