#include <stdio.h>
#include <assert.h>
#include <stdlib.h>

#define SHOW(x, fmt) printf( #x ": " fmt "\n", x )

#ifdef ERRS
#define ERR(...) __VA_ARGS__
#else
#define ERR(...)
#endif



int main() {
	float a[3][10];
	static_assert(sizeof(float)==4);			$\C{// floats (atomic elements) are 4 bytes}$
	static_assert(sizeof(void*)==8);			$\C{// pointers are 8 bytes}$

	static_assert(sizeof( a ) == 120);			$\C{// the array, float[3][10]}$
	static_assert(sizeof( a[0] ) == 40);		$\C{// its first element, float[10]}$
	static_assert(sizeof( a[0][0] ) == 4 );		$\C{// its first grand element, float}$

	static_assert(sizeof(&(a)) == 8);			$\C{// pointer to the array, float(*)[3][10]}$
	static_assert(sizeof(&(a[0])) == 8  );		$\C{// pointer to its first element, float(*)[10]}$
	static_assert(sizeof(&(a[0][0])) == 8  );	$\C{// pointer to its first grand-element, float*}$

	float (*pa  )[3][10] = &(a	  );
	float (*pa0 )   [10] = &(a[0]   );
	float  *pa00		 = &(a[0][0]);

	static_assert((void*)&a == (void*)&(a[0]   ));
	static_assert((void*)&a == (void*)&(a[0][0]));

	assert( (void *) pa == (void *) pa0  );
	assert( (void *) pa == (void *) pa00 );

//	float (*b[3])[10];
	float *b[3];
	for (int i = 0; i < 3; i ++) {
		b[i] = malloc(sizeof(float[10]));
	}
	a[2][3];
	b[2][3];
/*

*/

}

// Local Variables: //
// compile-command: "sed -f sedcmd bkgd-carray-mdim.c | gcc -x c -" //
// End: //
